package gov.va.med.mhv.mrp.web.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import gov.va.med.mhv.mrp.enums.GoalExtensionTypeEnumeration;


public class MyGoalsExtension implements Serializable {
	private static final long serialVersionUID = 8490818896167606374L;
	
	private Long goalExtensionId;
	private String description;
	private Integer goalExtensionSequenceNumber;
	private Integer goalExtensionType;
	private Integer oplock;
	private Boolean selected; // flag for goal samples
	private List<MyGoalTask> tasks = new ArrayList<MyGoalTask>();
	
	public boolean isStrength() {
		return GoalExtensionTypeEnumeration.STRENGTH.equals(GoalExtensionTypeEnumeration.findByCode(goalExtensionType));
	}

	public boolean isObstacle() {
		return GoalExtensionTypeEnumeration.OBSTACLE.equals(GoalExtensionTypeEnumeration.findByCode(goalExtensionType));
	}

	public boolean isReward() {
		return GoalExtensionTypeEnumeration.REWARD.equals(GoalExtensionTypeEnumeration.findByCode(goalExtensionType));
	}

	public Long getGoalExtensionId() {
		return goalExtensionId;
	}

	public void setGoalExtensionId(Long goalExtensionId) {
		this.goalExtensionId = goalExtensionId;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public Integer getGoalExtensionSequenceNumber() {
		return goalExtensionSequenceNumber;
	}

	public void setGoalExtensionSeqNo(Integer goalExtensionSeqNo) {
		this.goalExtensionSequenceNumber = goalExtensionSeqNo;
	}

	public Integer getGoalExtensionType() {
		return goalExtensionType;
	}

	public void setGoalExtensionType(Integer goalExtensionType) {
		this.goalExtensionType = goalExtensionType;
	}

	public Integer getOplock() {
		return oplock;
	}

	public void setOplock(Integer oplock) {
		this.oplock = oplock;
	}

	public Boolean getSelected() {
		return selected;
	}

	public void setSelected(Boolean selected) {
		this.selected = selected;
	}

	public List<MyGoalTask> getTasks() {
		return tasks;
	}

	public void setTasks(List<MyGoalTask> tasks) {
		this.tasks = tasks;
	}

	@Override
	public String toString() {
		return "MyGoalsExtension [goalExtensionId=" + goalExtensionId + ", description=" + description + ", goalExtensionSequenceNumber="
				+ goalExtensionSequenceNumber + ", goalExtensionType=" + goalExtensionType + ", oplock=" + oplock + ", selected=" + selected + ", tasks="
				+ tasks + "]";
	}

}
